// 2003/03/19 EntryPoint.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Windows.Forms;
using System.Threading;

using NTF.HXD.GUI;

namespace NTF.HXD
{
	public class EntryPoint
	{

		const string AppName = "HXDHelper";

		public EntryPoint()
		{
		}

		[STAThread]
		public static void Main(string[] args)
		{

			Appli appli = new Appli();

			if( appli.AppConfig.EnableMultipleBoot )
			{
				Application.Run( new MainForm(appli) );
			}
			else
			{
				bool bootable;
				Mutex m = new Mutex(true, AppName , out bootable);
				if (bootable)
				{
					m.WaitOne();
					Application.Run( new MainForm(appli) );
					m.ReleaseMutex();
				}
				else
				{
					MessageBox.Show ( "ɋNĂ܂BNł܂B" , AppName ,
						MessageBoxButtons.OK, MessageBoxIcon.Error);
				}
			}
		}

	}
}
